package ams7c9.embeddedsystemsproject;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Bundle;
import android.text.format.Time;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;


public class MainActivity extends Activity {

    public BluetoothAdapter mBluetoothAdapter = null;                                               //Instatiate the Bluetooth headers
    private BluetoothDevice bluetoothDevice = null;
    private BluetoothSocket bluetoothSocket = null;
    private OutputStream outputStream;                                                              //output and input streams for bluetooth
    private InputStream inputStream;
    public String deviceName = "00:06:66:68:17:D8";                                                 //My android device

    public TextView curretTemp = (TextView) findViewById(R.id.textCurrentTemp);                     //Declare TextView Variables
    public TextView alarmSet = (TextView) findViewById(R.id.textAlarmSet);                     //Declare TextView Variables

    public int i = 0;
    private String newMessage;
    private String messageParts[];


    @Override
    protected void onCreate(Bundle savedInstanceState) {                                            //On create see if device supports bluetooth
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBluetoothAdapter == null) {
            Toast.makeText(getApplicationContext(), "ERROR - Device does not support Bluetooth", Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onStart() {                                                                         //on start
        super.onStart();

        Thread connectionThread = new Thread(new Runnable() {
            @Override
            public void run() {

                while (true) {

                    if (!mBluetoothAdapter.isEnabled()) {                                           //while the bluetooth is enabled on the phone
                        //Check to see is the Bluetooth is enabled
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Toast.makeText(getApplicationContext(), "ERROR - Please enable your Bluetooth", Toast.LENGTH_SHORT).show();
                                                                                                    //if it isn't enabled
                            }
                        });

                        try {
                            Thread.sleep(500);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }

                    else {
                        break;
                    }
                }

                while (true) {

                    Set<BluetoothDevice> availableDevices = mBluetoothAdapter.getBondedDevices();   //check all avaible devices

                    if (availableDevices.size() > 0) {                                              //compile the avalible devices into a set
                        for (BluetoothDevice x : availableDevices) {
                            if (x.getAddress().equals(deviceName)) {
                                bluetoothDevice = x;                                                //check if any of the devices are mine

                                break;
                            }
                        }
                    }

                    if (bluetoothDevice == null) {                                                  //check if we could connect
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Toast.makeText(getApplicationContext(), "ERROR - Couldn't connect to the Bluetooth device", Toast.LENGTH_SHORT).show();
                            }

                        });

                        try {
                            Thread.sleep(500);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }

                    } else {
                        break;
                    }
                }

                while(true) {
                    UUID uuid = UUID.fromString("94f39d29-7d6d-437d-973b-fba39e49d4ee");            //UUID of my raspberry pi
                    try {
                        bluetoothSocket = bluetoothDevice.createRfcommSocketToServiceRecord(uuid);
                        bluetoothSocket.connect();

                        outputStream = bluetoothSocket.getOutputStream();
                        inputStream = bluetoothSocket.getInputStream();

                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    if (bluetoothSocket.isConnected()) {                                            //check if connected before continuing on
                        break;
                    }
                }


                while (true) {
                    byte inByte, buffer[] = new byte[1024];  //Give the buffer 1 kB of data         //read in information
                    int currentTemp;
                    i = 0;

                    try {

                        while ((inByte = (byte) inputStream.read()) != '#') {                       //Check for a delimiter
                            buffer[i++] = inByte;
                        }

                        buffer[i] = '\0';

                        newMessage = new String(buffer);                                            //Store the message
                        currentTemp.setText(newMessage.trim());                                     //set the current temp on the phone


                        if (alarmSet.toString().toUpperCase().equals("On"))                         //send the proper info for the alarm to the Raspberry Pi
                            outputStream.write(1);
                        else
                            outputStream.write(0);

                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }

                    //Check button press

                    //send data
                }
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
